## Explicit association
# Question ID 6	= Wie maakt het makkelijkst vrienden en werkt het liefst samen?
# Question ID 11 = Programmeurs maken makkelijk vrienden en werken graag samen.
# question ID 9 = Welk beroep vind jij iets voor meisjes?
# question ID 10 = Welk beroep vind jij iets voor jongens?
# question ID 13 = Programmeur zijn, dat is een beroep voor
# Question ID 7	Wie speelt er het liefste videospelletjes?
# Question ID 8	Wie speelt er het liefste tennis?
# Question 12 Programmeurs zijn gek op computers en hebben weinig andere hobby’s.

library(ggplot2)
library(effsize)
source('functions_results.R')

nmr = 7
numbers_on_eit(nmr, answers_control)

merge_answers_participants <- merge_answers_specific_question_participants(nmr, part_control,answers_control)
answers_question <- answers_on_question_id(nmr, answers_control)

t.test(answers_question$answers, mu=3)

# gender
table(merge_answers_participants$gender)
aggregate(merge_answers_participants$answers,by=list(merge_answers_participants$gender), FUN=mean)

t_test_boys_vs_girls_on_question_id(nmr, part_control, answers_control) # boys vs girls
effect_boys_vs_girls_on_question_id(nmr, part_control, answers_control)

# age correlation
table(merge_answers_participants$age_category)
aggregate(merge_answers_participants$answers,by=list(merge_answers_participants$age_category), FUN=mean)

#merge_answers_participants <- merge_answers_specific_question_participants(nmr, part_control,answers_control)
cor.test(merge_answers_participants$answers, merge_answers_participants$age)
cor.test(merge_answers_participants$answers, merge_answers_participants$age_category)

mean_d_per_age <- aggregate(merge_answers_participants$answers,by=list(merge_answers_participants$age), FUN=mean)
ggplot(mean_d_per_age, aes(x=Group.1, y=x)) + geom_point() + xlab('Age') +
  ylab('Score interests-videogaming') + scale_x_continuous(breaks = seq(7, 18, 1)) + 
  theme(text = element_text(size = 16))

mean_d_per_agecategory <- aggregate(merge_answers_participants$answers,by=list(merge_answers_participants$age_category), FUN=mean)
ggplot(mean_d_per_agecategory, aes(x=Group.1, y=x)) + geom_point() + xlab('Age') +
  ylab('Score Interest_videogaming') + 
  theme(text = element_text(size = 16))

rm(merge_answers_participants)

# experience - Yes, No, Yes-school, Yes-home, Yes-outofschool
m_experienced <- participants_experience(merge_answers_participants, "Yes")
m_experienced_libary_codeclub <- participants_experience(merge_answers_participants, "Yes-outofschool")
m_experienced_home <- participants_experience(merge_answers_participants, "Yes-home")
m_experienced_school <- participants_experience(merge_answers_participants, "Yes-school")
m_not_experienced <- participants_experience(merge_answers_participants, "No")

c(
  length(m_experienced$answers),
  length(m_experienced_libary_codeclub$answers),
  length(m_experienced_home$answers),
  length(m_experienced_school$answers),
  length(m_not_experienced$answers)
)

c(
mean(m_experienced$answers),
mean(m_experienced_libary_codeclub$answers),
mean(m_experienced_home$answers),
mean(m_experienced_school$answers),
mean(m_not_experienced$answers)
)

t_test_experience_on_question_id(nmr, part_control, answers_control, "Yes", "No")
t_test_experience_on_question_id(nmr, part_control, answers_control, "Yes", "Yes-school")
t_test_experience_on_question_id(nmr, part_control, answers_control, "Yes", "Yes-home")
t_test_experience_on_question_id(nmr, part_control, answers_control, "Yes", "Yes-outofschool")
t_test_experience_on_question_id(nmr, part_control, answers_control, "No", "Yes-school")
t_test_experience_on_question_id(nmr, part_control, answers_control, "No", "Yes-home")
t_test_experience_on_question_id(nmr, part_control, answers_control, "No", "Yes-outofschool")
t_test_experience_on_question_id(nmr, part_control, answers_control, "Yes-school", "Yes-home")
t_test_experience_on_question_id(nmr, part_control, answers_control, "Yes-home", "Yes-outofschool")

# familiar - Yes, Yes-often, Yes-not-often, Yes-media, No 
familiar <- participants_familiar(merge_answers_participants, "Yes")
familiar_often <- participants_familiar(merge_answers_participants, "Yes-often")
familiar_not_often <- participants_familiar(merge_answers_participants, "Yes-not-often")
familiar_media <- participants_familiar(merge_answers_participants, "Yes-media")
not_familiar <- participants_familiar(merge_answers_participants, "No")

c(
  length(familiar$answers),
  length(familiar_often$answers),
  length(familiar_not_often$answers),
  length(familiar_media$answers),
  length(not_familiar$answers)
)

c(
mean(familiar$answers),
mean(familiar_often$answers),
mean(familiar_not_often$answers),
mean(familiar_media$answers),
mean(not_familiar$answers)
)

t_test_familiar_on_question_id(nmr, part_control, answers_control, "Yes", "No")
t_test_familiar_on_question_id(nmr, part_control, answers_control, "Yes", "Yes-often")
t_test_familiar_on_question_id(nmr, part_control, answers_control, "Yes", "Yes-not-often")
t_test_familiar_on_question_id(nmr, part_control, answers_control, "Yes", "Yes-media")
t_test_familiar_on_question_id(nmr, part_control, answers_control, "No", "Yes-often")
t_test_familiar_on_question_id(nmr, part_control, answers_control, "No", "Yes-not-often")
t_test_familiar_on_question_id(nmr, part_control, answers_control, "No", "Yes-media")

t_test_familiar_on_question_id(nmr, part_control, answers_control, "Yes-not-often", "Yes-often")
effect_familiar_on_question_id(nmr, part_control, answers_control, "Yes-not-often", "Yes-often")

t_test_familiar_on_question_id(nmr, part_control, answers_control, "Yes-media", "Yes-not-often")
t_test_familiar_on_question_id(nmr, part_control, answers_control, "Yes-often", "Yes-media")



