#run datasets-EIT 

## Explicit association
# question ID 9 = Welk beroep vind jij iets voor meisjes?
# question ID 10 = Welk beroep vind jij iets voor jongens?
# question ID 13 = Programmeur zijn, dat is een beroep voor

# Question ID 6	= Wie maakt het makkelijkst vrienden en werkt het liefst samen?
# Question ID 11 = Programmeurs maken makkelijk vrienden en werken graag samen.

# Question ID 7	Wie speelt er het liefste videospelletjes?
# Question ID 8	Wie speelt er het liefste tennis?
# Question 12 Programmeurs zijn gek op computers en hebben weinig andere hobby’s

source("functions_results.R")
library(effsize)

nmr = 10
numbers_on_eit(nmr, answers_control)
numbers_on_eit(nmr, answers_interv_all)
numbers_on_eit(nmr, answers_interv_female)
numbers_on_eit(nmr, answers_interv_male)

t_test_on_question_id(nmr, answers_control, answers_interv_all)
effect_size_on_question_id(nmr, answers_control, answers_interv_all)

t_test_on_question_id(nmr, answers_control, answers_interv_female)
effect_size_on_question_id(nmr, answers_control, answers_interv_female)

t_test_on_question_id(nmr, answers_control, answers_interv_male)
effect_size_on_question_id(nmr, answers_control, answers_interv_male)

t_test_on_question_id(nmr, answers_interv_female, answers_interv_male)
effect_size_on_question_id(nmr, answers_interv_female, answers_interv_male)

# Gender
## Between
gender = "Jongen"
t_test_gender_on_question_id(nmr, part_control, answers_control, gender, 
                             part_interv_all, answers_interv_all, gender)
effect_size_gender_on_question_id(nmr, part_control, answers_control, gender, 
                             part_interv_all, answers_interv_all, gender)

t_test_gender_on_question_id(nmr, part_control, answers_control, gender, 
                             part_interv_female, answers_interv_female, gender)
t_test_gender_on_question_id(nmr, part_control, answers_control, gender, 
                             part_interv_male, answers_interv_male, gender)
t_test_gender_on_question_id(nmr, part_interv_female, answers_interv_female, gender, 
                             part_interv_male, answers_interv_male, gender)

gender = "Meisje"
t_test_gender_on_question_id(nmr, part_control, answers_control, gender, 
                             part_interv_all, answers_interv_all, gender)
t_test_gender_on_question_id(nmr, part_control, answers_control, gender, 
                             part_interv_female, answers_interv_female, gender)
t_test_gender_on_question_id(nmr, part_control, answers_control, gender, 
                             part_interv_male, answers_interv_male, gender)
t_test_gender_on_question_id(nmr, part_interv_female, answers_interv_female, gender, 
                             part_interv_male, answers_interv_male, gender)

# Age
participants_merged_answers_id <- merge_answers_specific_question_participants(nmr, part_control, answers_control)
part_control_po <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==1)
part_control_mix <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==2)
part_control_vo <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==3)

participants_merged_answers_id <- merge_answers_specific_question_participants(nmr, part_interv_all, answers_interv_all)
part_interv_all_po <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==1)
part_interv_all_mix <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==2)
part_interv_all_vo <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==3)

participants_merged_answers_id <- merge_answers_specific_question_participants(nmr, part_interv_female, answers_interv_female)
part_interv_female_po <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==1)
part_interv_female_mix <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==2)
part_interv_female_vo <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==3)

participants_merged_answers_id <- merge_answers_specific_question_participants(nmr, part_interv_male, answers_interv_male)
part_interv_male_po <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==1)
part_interv_male_mix <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==2)
part_interv_male_vo <- subset(participants_merged_answers_id, participants_merged_answers_id$age_category==3)

## Between group
#cat po
t.test(part_control_po$answers, part_interv_all_po$answers)
t.test(part_control_po$answers, part_interv_female_po$answers)

t.test(part_control_po$answers, part_interv_male_po$answers)
cohen.d(part_control_po$answers, part_interv_male_po$answers)

t.test(part_interv_female_po$answers, part_interv_male_po$answers)
cohen.d(part_interv_female_po$answers, part_interv_male_po$answers)

#cat mix
t.test(part_control_mix$answers, part_interv_all_mix$answers)
cohen.d(part_control_mix$answers, part_interv_all_mix$answers)

t.test(part_control_mix$answers, part_interv_female_mix$answers)
cohen.d(part_control_mix$answers, part_interv_female_mix$answers)

t.test(part_control_mix$answers, part_interv_male_mix$answers)
cohen.d(part_control_mix$answers, part_interv_male_mix$answers)

t.test(part_interv_female_mix$answers, part_interv_male_mix$answers)

#cat vo
t.test(part_control_vo$answers, part_interv_all_vo$answers)

t.test(part_control_vo$answers, part_interv_female_vo$answers)
cohen.d(part_control_vo$answers, part_interv_female_vo$answers)

t.test(part_control_vo$answers, part_interv_male_vo$answers)
t.test(part_interv_female_vo$answers, part_interv_male_vo$answers)

rm(part_control_po, part_control_mix, part_control_vo)
rm(part_interv_all_po, part_interv_all_mix, part_interv_all_vo)
rm(part_interv_female_po, part_interv_female_mix, part_interv_female_vo)
rm(part_interv_male_po, part_interv_male_mix, part_interv_male_vo)

# experience 
## within
participants_subset <- merge_answers_specific_question_participants(nmr, part_control, answers_control)
control_experienced <- participants_experience(participants_subset, "Yes")
control_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
control_experienced_home <- participants_experience(participants_subset, "Yes-home")
control_experienced_school <- participants_experience(participants_subset, "Yes-school")
control_not_experienced <- participants_experience(participants_subset, "No")

participants_subset <- merge_answers_specific_question_participants(nmr, part_interv_all, answers_interv_all)
interv_experienced <- participants_experience(participants_subset, "Yes")
interv_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
interv_experienced_home <- participants_experience(participants_subset, "Yes-home")
interv_experienced_school <- participants_experience(participants_subset, "Yes-school")
interv_not_experienced <- participants_experience(participants_subset, "No")

participants_subset <- merge_answers_specific_question_participants(nmr, part_interv_female, answers_interv_female)
interv_female_experienced <- participants_experience(participants_subset, "Yes")
interv_female_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
interv_female_experienced_home <- participants_experience(participants_subset, "Yes-home")
interv_female_experienced_school <- participants_experience(participants_subset, "Yes-school")
interv_female_not_experienced <- participants_experience(participants_subset, "No")

participants_subset <- merge_answers_specific_question_participants(nmr, part_interv_male, answers_interv_male) 
interv_male_experienced <- participants_experience(participants_subset, "Yes")
interv_male_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
interv_male_experienced_home <- participants_experience(participants_subset, "Yes-home")
interv_male_experienced_school <- participants_experience(participants_subset, "Yes-school")
interv_male_not_experienced <- participants_experience(participants_subset, "No")

#between
#experienced
t.test(control_experienced$answers, interv_experienced$answers)
t.test(control_experienced$answers, interv_female_experienced$answers)

t.test(control_experienced$answers, interv_male_experienced$answers)
cohen.d(control_experienced$answers, interv_male_experienced$answers)

t.test(interv_female_experienced$answers, interv_male_experienced$answers)

#not experienced
t.test(control_not_experienced$answers, interv_not_experienced$answers)

t.test(control_not_experienced$answers, interv_female_not_experienced$answers)
cohen.d(control_not_experienced$answers, interv_female_not_experienced$answers)

t.test(control_not_experienced$answers, interv_male_not_experienced$answers)

t.test(interv_female_not_experienced$answers, interv_male_not_experienced$answers)
cohen.d(interv_female_not_experienced$answers, interv_male_not_experienced$answers)

#out of school
t.test(control_experienced_libary_codeclub$answers, interv_experienced_libary_codeclub$answers)
t.test(control_experienced_libary_codeclub$answers, interv_female_experienced_libary_codeclub$answers)

t.test(control_experienced_libary_codeclub$answers, interv_male_experienced_libary_codeclub$answers)
cohen.d(control_experienced_libary_codeclub$answers, interv_male_experienced_libary_codeclub$answers)

t.test(interv_female_experienced_libary_codeclub$answers, interv_male_experienced_libary_codeclub$answers)
cohen.d(interv_female_experienced_libary_codeclub$answers, interv_male_experienced_libary_codeclub$answers)

#school
t.test(control_experienced_school$answers, interv_experienced_school$answers)
t.test(control_experienced_school$answers, interv_female_experienced_school$answers)

t.test(control_experienced_school$answers, interv_male_experienced_school$answers)
cohen.d(control_experienced_school$answers, interv_male_experienced_school$answers)

t.test(interv_female_experienced_school$answers, interv_male_experienced_school$answers)
cohen.d(interv_female_experienced_school$answers, interv_male_experienced_school$answers)

#home
t.test(control_experienced_home$answers, interv_experienced_home$answers)
cohen.d(control_experienced_home$answers, interv_experienced_home$answers)

t.test(control_experienced_home$answers, interv_female_experienced_home$answers)

t.test(control_experienced_home$answers, interv_male_experienced_home$answers)
cohen.d(control_experienced_home$answers, interv_male_experienced_home$answers)

t.test(interv_female_experienced_home$answers, interv_male_experienced_home$answers)

rm(control_experienced, control_not_experienced, control_experienced_libary_codeclub, control_experienced_home, control_experienced_school)

# familiar
participants_subset <- merge_answers_specific_question_participants(nmr, part_control, answers_control)
control_familiar <- participants_familiar(participants_subset, "Yes")
control_familiar_often <- participants_familiar(participants_subset, "Yes-often")
control_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
control_familiar_media <- participants_familiar(participants_subset, "Yes-media")
control_not_familiar <- participants_familiar(participants_subset, "No")

participants_subset <- merge_answers_specific_question_participants(nmr, part_interv_all, answers_interv_all)
interv_familiar <- participants_familiar(participants_subset, "Yes")
interv_familiar_often <- participants_familiar(participants_subset, "Yes-often")
interv_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
interv_familiar_media <- participants_familiar(participants_subset, "Yes-media")
interv_not_familiar <- participants_familiar(participants_subset, "No")

participants_subset <- merge_answers_specific_question_participants(nmr, part_interv_female, answers_interv_female)
interv_female_familiar <- participants_familiar(participants_subset, "Yes")
interv_female_familiar_often <- participants_familiar(participants_subset, "Yes-often")
interv_female_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
interv_female_familiar_media <- participants_familiar(participants_subset, "Yes-media")
interv_female_not_familiar <- participants_familiar(participants_subset, "No")

participants_subset <- merge_answers_specific_question_participants(nmr, part_interv_male, answers_interv_male)
interv_male_familiar <- participants_familiar(participants_subset, "Yes")
interv_male_familiar_often <- participants_familiar(participants_subset, "Yes-often")
interv_male_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
interv_male_familiar_media <- participants_familiar(participants_subset, "Yes-media")
interv_male_not_familiar <- participants_familiar(participants_subset, "No")

#between
#Yes
t.test(control_familiar$answers, interv_familiar$answers)
cohen.d(control_familiar$answers, interv_familiar$answers)

t.test(control_familiar$answers, interv_female_familiar$answers)
cohen.d(control_familiar$answers, interv_female_familiar$answers)

t.test(control_familiar$answers, interv_male_familiar$answers)
t.test(interv_female_familiar$answers, interv_male_familiar$answers)

#No
t.test(control_not_familiar$answers, interv_not_familiar$answers)

t.test(control_not_familiar$answers, interv_female_not_familiar$answers)
cohen.d(control_not_familiar$answers, interv_female_not_familiar$answers)

t.test(control_not_familiar$answers, interv_male_not_familiar$answers)
t.test(interv_female_not_familiar$answers, interv_male_not_familiar$answers)

#Yes - often
t.test(control_familiar_often$answers, interv_familiar_often$answers)
cohen.d(control_familiar_often$answers, interv_familiar_often$answers)

t.test(control_familiar_often$answers, interv_female_familiar_often$answers)
t.test(control_familiar_often$answers, interv_male_familiar_often$answers)
t.test(interv_female_familiar_often$answers, interv_male_familiar_often$answers)

#Yes - not often
t.test(control_familiar_not_often$answers, interv_familiar_not_often$answers)
t.test(control_familiar_not_often$answers, interv_female_familiar_not_often$answers)
t.test(control_familiar_not_often$answers, interv_male_familiar_not_often$answers)

t.test(interv_female_familiar_not_often$answers, interv_male_familiar_not_often$answers)
cohen.d(interv_female_familiar_not_often$answers, interv_male_familiar_not_often$answers)

#Yes - media
t.test(control_familiar_media$answers, interv_familiar_media$answers)
t.test(control_familiar_media$answers, interv_female_familiar_media$answers)

t.test(control_familiar_media$answers, interv_male_familiar_media$answers)
cohen.d(control_familiar_media$answers, interv_male_familiar_media$answers)

t.test(interv_female_familiar_media$answers, interv_male_familiar_media$answers)
cohen.d(interv_female_familiar_media$answers, interv_male_familiar_media$answers)
