library(ggplot2)

getmode <- function(v) {
  uniqv <- unique(v)
  uniqv[which.max(tabulate(match(v, uniqv)))]
}

### programming experience
table(participants_control_exp_no$q5)
getmode(participants_control_exp_no$q5)
median(participants_control_exp_no$q5)

table(participants_control_exp_yes$q5)
getmode(participants_control_exp_yes$q5)
median(participants_control_exp_yes$q5)

table(participants_control_exp_yes_home$q5)
getmode(participants_control_exp_yes_home$q5)
median(participants_control_exp_yes_home$q5)

table(participants_control_exp_yes_outofschool$q5)
getmode(participants_control_exp_yes_outofschool$q5)
median(participants_control_exp_yes_outofschool$q5)

table(participants_control_exp_yes_school$q5)
getmode(participants_control_exp_yes_school$q5)
median(participants_control_exp_yes_school$q5)

wilcox.test(participants_control_exp_no$q5, participants_control_exp_yes$q5)
wilcox.test(participants_control_exp_no$q5, participants_control_exp_yes_home$q5)
model <- wilcox.test(participants_control_exp_no$q5, participants_control_exp_yes_home$q5)
N <- 87+35
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_control_exp_no$q5, participants_control_exp_yes_outofschool$q5)
model <- wilcox.test(participants_control_exp_no$q5, participants_control_exp_yes_outofschool$q5)
N <- 87+21
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_control_exp_no$q5, participants_control_exp_yes_school$q5)

wilcox.test(participants_control_exp_yes$q5, participants_control_exp_yes_home$q5)
wilcox.test(participants_control_exp_yes$q5, participants_control_exp_yes_outofschool$q5)
wilcox.test(participants_control_exp_yes$q5, participants_control_exp_yes_school$q5)

wilcox.test(participants_control_exp_yes_home$q5, participants_control_exp_yes_outofschool$q5)
wilcox.test(participants_control_exp_yes_home$q5, participants_control_exp_yes_school$q5)
wilcox.test(participants_control_exp_yes_outofschool$q5, participants_control_exp_yes_school$q5)

# gender
# girls
table(participants_girls_exp_no$q5)
getmode(participants_girls_exp_no$q5)
median(participants_girls_exp_no$q5)

table(participants_girls_exp_yes$q5)
getmode(participants_girls_exp_yes$q5)
median(participants_girls_exp_yes$q5)

table(participants_girls_exp_yes_home$q5)
getmode(participants_girls_exp_yes_home$q5)
median(participants_girls_exp_yes_home$q5)

table(participants_girls_exp_yes_outofschool$q5)
getmode(participants_girls_exp_yes_outofschool$q5)
median(participants_girls_exp_yes_outofschool$q5)

table(participants_girls_exp_yes_school$q5)
getmode(participants_girls_exp_yes_school$q5)
median(participants_girls_exp_yes_school$q5)

wilcox.test(participants_girls_exp_no$q5, participants_girls_exp_yes$q5)
wilcox.test(participants_girls_exp_no$q5, participants_girls_exp_yes_home$q5)
wilcox.test(participants_girls_exp_no$q5, participants_girls_exp_yes_outofschool$q5)
model <- wilcox.test(participants_girls_exp_no$q5, participants_girls_exp_yes_outofschool$q5)
N <- 48+8
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_girls_exp_no$q5, participants_girls_exp_yes_school$q5)

wilcox.test(participants_girls_exp_yes$q5, participants_girls_exp_yes_home$q5)
wilcox.test(participants_girls_exp_yes$q5, participants_girls_exp_yes_outofschool$q5)
wilcox.test(participants_girls_exp_yes$q5, participants_girls_exp_yes_school$q5)

wilcox.test(participants_girls_exp_yes_home$q5, participants_girls_exp_yes_outofschool$q5)
wilcox.test(participants_girls_exp_yes_home$q5, participants_girls_exp_yes_school$q5)
wilcox.test(participants_girls_exp_yes_outofschool$q5, participants_girls_exp_yes_school$q5)

# gender - boys
table(participants_boys_exp_no$q5)
getmode(participants_boys_exp_no$q5)
median(participants_boys_exp_no$q5)

table(participants_boys_exp_yes$q5)
getmode(participants_boys_exp_yes$q5)
median(participants_boys_exp_yes$q5)

table(participants_boys_exp_yes_home$q5)
getmode(participants_boys_exp_yes_home$q5)
median(participants_boys_exp_yes_home$q5)

table(participants_boys_exp_yes_outofschool$q5)
getmode(participants_boys_exp_yes_outofschool$q5)
median(participants_boys_exp_yes_outofschool$q5)

table(participants_boys_exp_yes_school$q5)
getmode(participants_boys_exp_yes_school$q5)
median(participants_boys_exp_yes_school$q5)

wilcox.test(participants_boys_exp_no$q5, participants_boys_exp_yes$q5)
wilcox.test(participants_boys_exp_no$q5, participants_boys_exp_yes_home$q5)
model <- wilcox.test(participants_boys_exp_no$q5, participants_boys_exp_yes_home$q5)
N <- 27+19
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_boys_exp_no$q5, participants_boys_exp_yes_outofschool$q5)
wilcox.test(participants_boys_exp_no$q5, participants_boys_exp_yes_school$q5)

wilcox.test(participants_boys_exp_yes$q5, participants_boys_exp_yes_home$q5)
wilcox.test(participants_boys_exp_yes$q5, participants_boys_exp_yes_outofschool$q5)
wilcox.test(participants_boys_exp_yes$q5, participants_boys_exp_yes_school$q5)

wilcox.test(participants_boys_exp_yes_home$q5, participants_boys_exp_yes_outofschool$q5)
wilcox.test(participants_boys_exp_yes_home$q5, participants_boys_exp_yes_school$q5)
model <- wilcox.test(participants_boys_exp_yes_home$q5, participants_boys_exp_yes_school$q5)
N <- 19+38
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_boys_exp_yes_outofschool$q5, participants_boys_exp_yes_school$q5)

# boys vs girls
wilcox.test(participants_boys_exp_no$q5, participants_girls_exp_no$q5)
model <- wilcox.test(participants_boys_exp_no$q5, participants_girls_exp_no$q5)
N <- 27+48
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_boys_exp_yes$q5, participants_girls_exp_yes$q5)
model <- wilcox.test(participants_boys_exp_yes$q5, participants_girls_exp_yes$q5)
N <- 58+49
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_boys_exp_yes_home$q5, participants_girls_exp_yes_home$q5)
model <- wilcox.test(participants_boys_exp_yes_home$q5, participants_girls_exp_yes_home$q5)
N <- 19+14
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(participants_boys_exp_yes_outofschool$q5, participants_girls_exp_yes_outofschool$q5)
wilcox.test(participants_boys_exp_yes_school$q5, participants_girls_exp_yes_school$q5)

# age 7-8
exp_no_78 = subset(participants_control_exp_no, participants_control_exp_no$age_category == 1)
exp_yes_78 = subset(participants_control_exp_yes, participants_control_exp_yes$age_category == 1)
exp_home_78 = subset(participants_control_exp_yes_home, participants_control_exp_yes_home$age_category == 1)
exp_outofschool_78 = subset(participants_control_exp_yes_outofschool, participants_control_exp_yes_outofschool$age_category == 1)
exp_school_78 = subset(participants_control_exp_yes_school, participants_control_exp_yes_school$age_category == 1)

table(exp_no_78$q5)
getmode(exp_no_78$q5)
median(exp_no_78$q5)

table(exp_yes_78$q5)
getmode(exp_yes_78$q5)
median(exp_yes_78$q5)

table(exp_home_78$q5)
getmode(exp_home_78$q5)
median(exp_home_78$q5)

table(exp_outofschool_78$q5)
getmode(exp_outofschool_78$q5)
median(exp_outofschool_78$q5)

table(exp_school_78$q5)
getmode(exp_school_78$q5)
median(exp_school_78$q5)

wilcox.test(exp_no_78$q5, exp_yes_78$q5)
wilcox.test(exp_no_78$q5, exp_home_78$q5)
wilcox.test(exp_no_78$q5, exp_outofschool_78$q5)
wilcox.test(exp_no_78$q5, exp_school_78$q5)

wilcox.test(exp_yes_78$q5, exp_home_78$q5)
wilcox.test(exp_yes_78$q5, exp_outofschool_78$q5)
wilcox.test(exp_yes_78$q5, exp_school_78$q5)

wilcox.test(exp_home_78$q5, exp_outofschool_78$q5)
wilcox.test(exp_home_78$q5, exp_school_78$q5)
wilcox.test(exp_outofschool_78$q5, exp_school_78$q5)

# age middle
exp_no_910 = subset(participants_control_exp_no, participants_control_exp_no$age_category == 2)
exp_yes_910 = subset(participants_control_exp_yes, participants_control_exp_yes$age_category == 2)
exp_home_910 = subset(participants_control_exp_yes_home, participants_control_exp_yes_home$age_category == 2)
exp_outofschool_910 = subset(participants_control_exp_yes_outofschool, participants_control_exp_yes_outofschool$age_category == 2)
exp_school_910 = subset(participants_control_exp_yes_school, participants_control_exp_yes_school$age_category == 2)

table(exp_no_910$q5)
getmode(exp_no_910$q5)
median(exp_no_910$q5)

table(exp_yes_910$q5)
getmode(exp_yes_910$q5)
median(exp_yes_910$q5)

table(exp_home_910$q5)
getmode(exp_home_910$q5)
median(exp_home_910$q5)

table(exp_outofschool_910$q5)
getmode(exp_outofschool_910$q5)
median(exp_outofschool_910$q5)

table(exp_school_910$q5)
getmode(exp_school_910$q5)
median(exp_school_910$q5)

wilcox.test(exp_no_910$q5, exp_yes_910$q5)
wilcox.test(exp_no_910$q5, exp_home_910$q5)
wilcox.test(exp_no_910$q5, exp_outofschool_910$q5)
wilcox.test(exp_no_910$q5, exp_school_910$q5)

wilcox.test(exp_yes_910$q5, exp_home_910$q5)
wilcox.test(exp_yes_910$q5, exp_outofschool_910$q5)
wilcox.test(exp_yes_910$q5, exp_school_910$q5)

wilcox.test(exp_home_910$q5, exp_outofschool_910$q5)
wilcox.test(exp_home_910$q5, exp_school_910$q5)
wilcox.test(exp_outofschool_910$q5, exp_school_910$q5)

# age older
exp_no_1112 = subset(participants_control_exp_no, participants_control_exp_no$age_category == 3)
exp_yes_1112 = subset(participants_control_exp_yes, participants_control_exp_yes$age_category == 3)
exp_home_1112 = subset(participants_control_exp_yes_home, participants_control_exp_yes_home$age_category == 3)
exp_outofschool_1112 = subset(participants_control_exp_yes_outofschool, participants_control_exp_yes_outofschool$age_category == 3)
exp_school_1112 = subset(participants_control_exp_yes_school, participants_control_exp_yes_school$age_category == 3)

table(exp_no_1112$q5)
getmode(exp_no_1112$q5)
median(exp_no_1112$q5)

table(exp_yes_1112$q5)
getmode(exp_yes_1112$q5)
median(exp_yes_1112$q5)

table(exp_home_1112$q5)
getmode(exp_home_1112$q5)
median(exp_home_1112$q5)

table(exp_outofschool_1112$q5)
getmode(exp_outofschool_1112$q5)
median(exp_outofschool_1112$q5)

table(exp_school_1112$q5)
getmode(exp_school_1112$q5)
median(exp_school_1112$q5)

wilcox.test(exp_no_1112$q5, exp_yes_1112$q5)
wilcox.test(exp_no_1112$q5, exp_home_1112$q5)
model <- wilcox.test(exp_no_1112$q5, exp_home_1112$q5)
N <- 21+8
z <- qnorm(model$p.value/2)
r <- z/sqrt(N)

wilcox.test(exp_no_1112$q5, exp_outofschool_1112$q5)
wilcox.test(exp_no_1112$q5, exp_school_1112$q5)

wilcox.test(exp_yes_1112$q5, exp_home_1112$q5)
wilcox.test(exp_yes_1112$q5, exp_outofschool_1112$q5)
wilcox.test(exp_yes_1112$q5, exp_school_1112$q5)

wilcox.test(exp_home_1112$q5, exp_outofschool_1112$q5)
wilcox.test(exp_home_1112$q5, exp_school_1112$q5)
wilcox.test(exp_outofschool_1112$q5, exp_school_1112$q5)

# age 13-14
exp_no_1314 = subset(participants_control_exp_no, participants_control_exp_no$age_category == 4)
exp_yes_1314 = subset(participants_control_exp_yes, participants_control_exp_yes$age_category == 4)
exp_home_1314 = subset(participants_control_exp_yes_home, participants_control_exp_yes_home$age_category == 4)
exp_outofschool_1314 = subset(participants_control_exp_yes_outofschool, participants_control_exp_yes_outofschool$age_category == 4)
exp_school_1314 = subset(participants_control_exp_yes_school, participants_control_exp_yes_school$age_category == 4)

table(exp_no_1314$q5)
getmode(exp_no_1314$q5)
median(exp_no_1314$q5)

table(exp_yes_1314$q5)
getmode(exp_yes_1314$q5)
median(exp_yes_1314$q5)

table(exp_home_1314$q5)
getmode(exp_home_1314$q5)
median(exp_home_1314$q5)

table(exp_outofschool_1314$q5)
getmode(exp_outofschool_1314$q5)
median(exp_outofschool_1314$q5)

table(exp_school_1314$q5)
getmode(exp_school_1314$q5)
median(exp_school_1314$q5)

wilcox.test(exp_no_1314$q5, exp_yes_1314$q5)
wilcox.test(exp_no_1314$q5, exp_home_1314$q5)
wilcox.test(exp_no_1314$q5, exp_outofschool_1314$q5)
wilcox.test(exp_no_1314$q5, exp_school_1314$q5)

wilcox.test(exp_yes_1314$q5, exp_home_1314$q5)
wilcox.test(exp_yes_1314$q5, exp_outofschool_1314$q5)
wilcox.test(exp_yes_1314$q5, exp_school_1314$q5)

wilcox.test(exp_home_1314$q5, exp_outofschool_1314$q5)
wilcox.test(exp_home_1314$q5, exp_school_1314$q5)
wilcox.test(exp_outofschool_1314$q5, exp_school_1314$q5)

# 7-8 vs 9-10
wilcox.test(exp_no_78$q5, exp_no_910$q5)
wilcox.test(exp_yes_78$q5, exp_yes_910$q5)
wilcox.test(exp_home_78$q5, exp_home_910$q5)
wilcox.test(exp_outofschool_78$q5, exp_outofschool_910$q5)
wilcox.test(exp_school_78$q5, exp_school_910$q5)

# 7-8 vs 11-12
wilcox.test(exp_no_78$q5, exp_no_1112$q5)
wilcox.test(exp_yes_78$q5, exp_yes_1112$q5)
wilcox.test(exp_home_78$q5, exp_home_1112$q5)
wilcox.test(exp_outofschool_78$q5, exp_outofschool_1112$q5)
wilcox.test(exp_school_78$q5, exp_school_1112$q5)

# 7-8 vs 13-14
wilcox.test(exp_no_78$q5, exp_no_1314$q5)
wilcox.test(exp_yes_78$q5, exp_yes_1314$q5)
wilcox.test(exp_home_78$q5, exp_home_1314$q5)
wilcox.test(exp_outofschool_78$q5, exp_outofschool_1314$q5)
wilcox.test(exp_school_78$q5, exp_school_1314$q5)

# 9-10 vs 11-12
wilcox.test(exp_no_910$q5, exp_no_1112$q5)
wilcox.test(exp_yes_910$q5, exp_yes_1112$q5)
wilcox.test(exp_home_910$q5, exp_home_1112$q5)
wilcox.test(exp_outofschool_910$q5, exp_outofschool_1112$q5)
wilcox.test(exp_school_910$q5, exp_school_1112$q5)

# 9-10 vs 13-14
wilcox.test(exp_no_910$q5, exp_no_1314$q5)
wilcox.test(exp_yes_910$q5, exp_yes_1314$q5)
wilcox.test(exp_home_910$q5, exp_home_1314$q5)
wilcox.test(exp_outofschool_910$q5, exp_outofschool_1314$q5)
wilcox.test(exp_school_910$q5, exp_school_1314$q5)

# 11-12 vs 13-14
wilcox.test(exp_no_1112$q5, exp_no_1314$q5)
wilcox.test(exp_yes_1112$q5, exp_yes_1314$q5)
wilcox.test(exp_home_1112$q5, exp_home_1314$q5)
wilcox.test(exp_outofschool_1112$q5, exp_outofschool_1314$q5)
wilcox.test(exp_school_1112$q5, exp_school_1314$q5)

rm(N, r, z, model)
rm(exp_home_1112, exp_home_1314, exp_home_78, exp_home_910)
rm(exp_no_1112, exp_no_1314, exp_no_78, exp_no_910)
rm(exp_outofschool_1112, exp_outofschool_1314, exp_outofschool_78, exp_outofschool_910)
rm(exp_school_1112, exp_school_1314, exp_school_78, exp_school_910)
rm(exp_yes_1112, exp_yes_1314, exp_yes_78, exp_yes_910)
