import pandas as pd
from scipy import stats
import numpy as np
import rqFunctions as rq

## Prepare data and dataset
programs = rq.importCSV('data.csv', False)
programs = rq.dropEmptyPrograms(programs, False)
user_gender = rq.unique_user_gender(programs, False)
user_gender_adventure = rq.group_user_gender_adventure(programs, False)
user_worked_on_binary = rq.users_worked_on(user_gender, user_gender_adventure, 'binary', False)
user_worked_on_amount = rq.users_worked_on(user_gender, user_gender_adventure, 'amount', False)

## Users and binary value of working on an adventure
if True:
    print("\nTESTING on BINARY - BETWEEN")

    print('BETWEEN - STORY') # is gender associated with working on stories
    # [worked on, not worked on] for boys, girls and others
    rq.chi_worked_on_between([861, 587], [800, 473], [56, 34]) #worked on, not worked - boys, girls, others

    print('BETWEEN - GAME') # is gender associated with working on games
    rq.chi_worked_on_between([1215, 233], [1100, 173], [76,14]) 

    print('BETWEEN - VISUALS') # is gender associated with working on visuals
    rq.chi_worked_on_between([1115, 333], [972, 301], [64,25]) 

if True:
    print("\nTESTING on BINARY - WITHIN")
    # [worked on, not worked on] for boys, girls and others
    print('WITHIN - BOYS') # is adventure associated with saving programs for a particular gender - male
    rq.chi_worked_on_within([861, 587], [1215, 233], [1115,333])

    print('WITHIN - GIRLS') # is adventure associated with saving programs for a particular gender - female
    rq.chi_worked_on_within([800, 473],[1100, 173], [972, 301])

    print('WITHIN - OTHERS') # is adventure associated with saving programs for a particular gender - other
    rq.chi_worked_on_within([56, 34],[76, 14], [64, 26]) 

## Saved programs per adventure
if True:
    print("\nMEAN and STD")
    rq.column_mean_std(user_worked_on_amount, 'story')
    rq.column_mean_std(user_worked_on_amount, 'game')
    rq.column_mean_std(user_worked_on_amount, 'visual')

if True:
    print("\nTESTING on AMOUNT")
    print("\nWITHIN GENDER")
    rq.ttest_within_gender_adv(user_worked_on_amount, 'm')
    rq.ttest_within_gender_adv(user_worked_on_amount, 'f')
    rq.ttest_within_gender_adv(user_worked_on_amount, 'o')

if True:
    print("\nBETWEEN GENDER")
    rq.ttest_between_gender_all(user_worked_on_amount, 'story')
    rq.ttest_between_gender_all(user_worked_on_amount, 'game')
    rq.ttest_between_gender_all(user_worked_on_amount, 'visual')
